<?php

class Login
{
    private $db_connection = null;
    public $errors = array();
    public $messages = array();

    public function __construct()
    {
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }

        if (isset($_GET["logout"])) {
            $this->doLogout();
        } elseif (isset($_POST["login"])) {
            $this->dologinWithPostData();
        }
    }

    private function dologinWithPostData()
    {
        if (empty($_POST['user_name'])) {
            $this->errors[] = "El usuario es obligatorio.";
        } elseif (empty($_POST['user_password'])) {
            $this->errors[] = "La contraseña es obligatoria.";
        } else {
            $this->db_connection = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

            if (!$this->db_connection->set_charset("utf8")) {
                $this->errors[] = $this->db_connection->error;
            }

            if (!$this->db_connection->connect_errno) {
                $user_name = $this->db_connection->real_escape_string($_POST['user_name']);

                $sql = "SELECT user_id, user_name, user_email, user_password_hash, firstname, lastname
                        FROM users
                        WHERE user_name = '$user_name' OR user_email = '$user_name' LIMIT 1";
                $result = $this->db_connection->query($sql);

                if ($result->num_rows == 1) {
                    $user = $result->fetch_object();
                    if (password_verify($_POST['user_password'], $user->user_password_hash)) {
                        $_SESSION['user_id']   = $user->user_id;
                        $_SESSION['user_name'] = $user->user_name;
                        $_SESSION['user_email']= $user->user_email;
                        $_SESSION['firstname'] = $user->firstname;
                        $_SESSION['lastname']  = $user->lastname;
                        $_SESSION['user_login_status'] = 1;
                    } else {
                        $this->errors[] = "Usuario o contraseña incorrectos.";
                    }
                } else {
                    $this->errors[] = "Usuario o contraseña incorrectos.";
                }
            } else {
                $this->errors[] = "Error de conexión con la base de datos.";
            }
        }
    }

    public function doLogout()
    {
        session_unset();
        session_destroy();
        $this->messages[] = "Has salido del sistema.";
    }

    public function isUserLoggedIn()
    {
        return (isset($_SESSION['user_login_status']) && $_SESSION['user_login_status'] == 1);
    }
}