<?php
require_once("../config/db.php");
require_once("../classes/Login.php");
$login = new Login();

if ($login->isUserLoggedIn()) {
    header("location: panel_admin.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <title>AcoraDoor - Login</title>
  <link rel="stylesheet" href="css/vendors_css.css">
  <link rel="stylesheet" href="css/style.css">
  <link rel="stylesheet" href="css/skin_color.css">
</head>
<body class="hold-transition theme-primary bg-img" style="background-image: url(../images/auth-bg/bg-2.jpg)">
  <div class="container h-p100"><br><br><br><br>
    <div class="row align-items-center justify-content-md-center h-p100">
      <div class="col-12">
        <div class="row justify-content-center g-0">
          <div class="col-lg-5 col-md-5 col-12">
            <div class="bg-white rounded10 shadow-lg">
              <div class="content-top-agile p-20 pb-0">
                <h2 class="text-primary">AcoraDoor</h2>
                <p class="mb-0">Inicio De Sesion.</p>
              </div>
              <div class="p-40">
                <form method="post" action="login.php" autocomplete="off">
                  <?php
                  if (!empty($login->errors)) {
                      echo '<div class="alert alert-danger"><strong>Error!</strong><br>';
                      foreach ($login->errors as $error) echo $error . "<br>";
                      echo '</div>';
                  }
                  if (!empty($login->messages)) {
                      echo '<div class="alert alert-success"><strong>Información!</strong><br>';
                      foreach ($login->messages as $message) echo $message . "<br>";
                      echo '</div>';
                  }
                  ?>
                  <div class="form-group">
                    <div class="input-group mb-3">
                      <span class="input-group-text bg-transparent"><i class="ti-user"></i></span>
                      <input class="form-control" placeholder="Usuario o Email" name="user_name" type="text" required>
                    </div>
                  </div>
                  <div class="form-group">
                    <div class="input-group mb-3">
                      <span class="input-group-text bg-transparent"><i class="ti-lock"></i></span>
                      <input class="form-control" placeholder="Contraseña" name="user_password" type="password" required>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-6">
                      <div class="checkbox">
                        <input type="checkbox" id="basic_checkbox_1">
                        <label for="basic_checkbox_1">Acuérdate de mí</label>
                      </div>
                    </div>
                    <div class="col-6 text-end">
                      <a href="#" class="hover-warning"><i class="ion ion-locked"></i> ¿Olvidaste la contraseña?</a>
                    </div>
                    <div class="col-12 text-center">
                      <button type="submit" class="btn btn-danger mt-10" name="login" id="submit">Conectar</button>
                    </div>
                  </div>
                </form>
                <div class="text-center">
                  <p class="mt-15 mb-0">¿No tienes una cuenta? <a href="auth_register.html" class="text-warning ms-5">Inscribirse</a></p>
                </div>
              </div>
            </div>
            <div class="text-center">
              <p class="mt-20 text-white">- Firma con -</p>
              <p class="gap-items-2 mb-20">
                <a class="btn btn-social-icon btn-round btn-facebook" href="#"><i class="fa fa-facebook"></i></a>
                <a class="btn btn-social-icon btn-round btn-twitter" href="#"><i class="fa fa-twitter"></i></a>
                <a class="btn btn-social-icon btn-round btn-instagram" href="#"><i class="fa fa-instagram"></i></a>
              </p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <script src="js/vendors.min.js"></script>
  <script src="js/pages/chat-popup.js"></script>
  <script src="../assets/icons/feather-icons/feather.min.js"></script>
</body>
</html>